PLUGINS.Devices.push({
    "name": "Eltex MES2448B info",
    "isApplicable": function (sysDescr) {
        return sysDescr.indexOf("MES2448B rev.B AC 52") !== -1;
    },
    "loadInfo": async function (device) {
        let info = [];

        info.push({
            "type": "header",
            "caption": "SFP Info"
        });


        for (const iface of device.interfaces) {
            if (iface.connections.length > 0) {

                info.push({
                    "type": "row",
                    "caption": iface.name + " RX Power Level",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.35265.52.1.1.3.2.1.8." + iface.index + ".5.1")) / 1000,
                    "units": "dBm"
                });
                info.push({
                    "type": "row",
                    "caption": iface.name + " TX Power Level",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.35265.52.1.1.3.2.1.8." + iface.index + ".4.1")) / 1000,
                    "units": "dBm"
                });

                info.push({
                    "type": "row",
                    "caption": iface.name + " wavelength",
                    "value": parseInt(await SNMP.get(device, "1.3.6.1.4.1.35265.52.1.1.3.1.1.4." + iface.index)),
                    "units": "nm"
                });
            }
        }

        return info;
    }
});